/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.palette;

import filenet.vw.api.VWMapNode;
import filenet.vw.toolkit.design.mapui.VWDesignerMapToolbar;
import filenet.vw.toolkit.design.palette.VWDraggablePaletteItemUI;
import filenet.vw.toolkit.design.palette.VWIconViewPanel;
import filenet.vw.toolkit.design.palette.VWStepPaletteDocumentHelper;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.utils.VWPopupMenu;
import java.awt.Container;

public abstract class VWBaseStepPalettePanel {
    protected VWIconViewPanel m_iconViewPanel = null;
    protected VWAuthPropertyData m_authPropertyData = null;

    public void initialize(VWAuthPropertyData authPropertyData, VWDesignerMapToolbar mapToolbar) {
        this.m_authPropertyData = authPropertyData;
        this.createControls(mapToolbar);
    }

    public abstract void addStepToPalette(String var1, VWMapNode var2) throws Exception;

    public void setSelected() {
    }

    public void releaseReferences() {
        if (this.m_iconViewPanel != null) {
            Container parent = this.m_iconViewPanel.getParent();
            if (parent != null) {
                parent.removeComponentListener(this.m_iconViewPanel);
            }
            this.m_iconViewPanel.releaseReferences();
            this.m_iconViewPanel = null;
        }
        this.m_authPropertyData = null;
    }

    protected abstract void createControls(VWDesignerMapToolbar var1);

    protected abstract VWPopupMenu getStepContextMenu();

    protected abstract void displayStepPaletteDialog();

    protected abstract VWDraggablePaletteItemUI getSelectedUIItem();

    protected abstract void setSelectedUIItem(VWDraggablePaletteItemUI var1);

    protected VWAuthPropertyData getAuthPropertyData() {
        return this.m_authPropertyData;
    }

    protected VWStepPaletteDocumentHelper getStepPaletteDocumentHelper() {
        return this.m_authPropertyData.getDesignerCoreData().getStepPaletteDocumentHelper();
    }
}

